#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#define MAX_N 20000
#define MAX_EDGES (MAX_N * MAX_N / 2)

int N_id[MAX_N];
double P_x[MAX_N];
double P_y[MAX_N];

int Q_orig_id[MAX_N];
double Q_x[MAX_N]; 
double Q_y[MAX_N];
int q_cnt=0;

int E_u[MAX_EDGES]; 
int E_v[MAX_EDGES];
double E_w[MAX_EDGES];
int e_cnt=0;

int T_u[MAX_N]; 
int T_v[MAX_N];
int t_e_cnt=0;

int predak[MAX_N]; 
int nadji_korencic(int i) {
    if(predak[i]==i)return i;
    return predak[i]=nadji_korencic(predak[i]);
}
void spoji(int i,int j) {
    int koren_i=nadji_korencic(i);
    int koren_j=nadji_korencic(j);
    if(koren_i!=koren_j){
        predak[koren_i]=koren_j;
    }
}

double menhetn_dist(double x1,double y1,double x2,double y2) {
    return fabs(x1-x2)+fabs(y1-y2);
}

int e_sort_idx[MAX_EDGES];
int cmp_e_idx(const void *a,const void *b) {
    int idx_a=*(int*)a;
    int idx_b=*(int*)b;
    if(E_w[idx_a]<E_w[idx_b])return -1;
    if(E_w[idx_a]>E_w[idx_b])return 1;
    return 0;
}


void resi() {
    int n;
    double eps;
    if(scanf("%d %lf",&n,&eps)!=2)return;

    for(int i=0;i<n;i++){
        if(scanf("%lf %lf",&P_x[i],&P_y[i])!=2)return;
        N_id[i]=i+1;
    }
    
    double s=eps/2.0;
    int L=(int)ceil(1.0/s);
    if(L==0)L=1;

    int max_g_s=L*L;
    if(max_g_s>4000000)max_g_s=4000000;
    
    int *rep_q_idx=(int*)malloc(max_g_s*sizeof(int));
    for(int i=0;i<max_g_s;i++)rep_q_idx[i]=-1;
    
    q_cnt=0;
    
    for(int i=0;i<n;i++){
        int idx_x=(int)floor(P_x[i]/s);
        if(idx_x>=L)idx_x=L-1; 
        int idx_y=(int)floor(P_y[i]/s);
        if(idx_y>=L)idx_y=L-1; 

        int g_idx=idx_y*L+idx_x;

        if(g_idx>=max_g_s)continue; 
        
        if(rep_q_idx[g_idx]==-1){
            rep_q_idx[g_idx]=q_cnt;
            
            Q_x[q_cnt]=P_x[i];
            Q_y[q_cnt]=P_y[i];
            Q_orig_id[q_cnt]=N_id[i];
            
            q_cnt++;
        }
    }

    if(q_cnt<=1){
        printf("%d\n",q_cnt);
        if(q_cnt==1)printf("%d\n",Q_orig_id[0]);
        printf("\n");
        free(rep_q_idx);
        return;
    }

    e_cnt=0;
    for(int i=0;i<q_cnt;i++){
        for(int j=i+1;j<q_cnt;j++){
            E_u[e_cnt]=i;
            E_v[e_cnt]=j;
            E_w[e_cnt]=menhetn_dist(Q_x[i],Q_y[i],Q_x[j],Q_y[j]);
            
            e_sort_idx[e_cnt]=e_cnt;
            e_cnt++;
        }
    }

    qsort(e_sort_idx,e_cnt,sizeof(int),cmp_e_idx);
    
    for(int i=0;i<q_cnt;i++){
        predak[i]=i;
    }

    t_e_cnt=0;
    
    for(int i=0;i<e_cnt&&t_e_cnt<q_cnt-1;i++){
        int curr_e_idx=e_sort_idx[i];
        int u=E_u[curr_e_idx];
        int v=E_v[curr_e_idx];
        
        if(nadji_korencic(u)!=nadji_korencic(v)){
            spoji(u,v);
            
            T_u[t_e_cnt]=u;
            T_v[t_e_cnt]=v;
            t_e_cnt++;
        }
    }

    printf("%d\n",q_cnt);
    for(int i=0;i<q_cnt;i++){
        printf("%d%c",Q_orig_id[i],(i==q_cnt-1)?'\n':' ');
    }
    for(int i=0;i<t_e_cnt;i++){
        int u_id=Q_orig_id[T_u[i]];
        int v_id=Q_orig_id[T_v[i]];
        printf("%d %d\n",u_id,v_id);
    }
    
    free(rep_q_idx);
}

int main() {
    resi();
    return 0;
}